@ECHO OFF
ECHO Microsoft Virtual PC 2004 Network Services Driver Installation

:: ======================================================================
:: File:		INSTALL.BAT
:: 
:: Contains:	This installs the Virtual PC drivers under Windows 2000/XP.
:: ======================================================================

:: Save the current directory
PUSHD

:: Is this Windows NT or Windows 2000/XP?
VER | FIND /I "Windows NT Version 4.0">NUL
IF NOT ERRORLEVEL 1 GOTO Fatal_WrongSystemVersion

:: Enable command extensions - See HELP SETLOCAL for information on the
:: following idiom.
VERIFY OTHER 2>NUL
SETLOCAL ENABLEEXTENSIONS
IF ERRORLEVEL 1 GOTO Fatal_UnableToEnableExtensions

:: Setup some common constants
SET NetInfName=VMNetSrv\VMNetSrv.inf

:: The source directory may be specified in the second batch parameter.
:: If the source directory is not specified, assume the source directory
:: is the current directory.
IF NOT ([%1] == []) CD /D %1
FOR /F "delims=" %%A IN ('CD') DO SET CurDir=%%A

:: Install the driver
RUNDLL32 "%CurDir%\InstSrvc.dll",InstallNetworkDriver %CurDir%\%NetInfName%

:: Notify user that install is complete
ECHO Driver installation is complete...

:: This makes sure we can execute this batch file without pausing at the end.
IF [%2]==[nopause] GOTO End
PAUSE
GOTO End

:Fatal_UnableToEnableExtensions
ECHO ERROR: Unable to enable command extensions.
GOTO End

:Fatal_WrongSystemVersion
ECHO ERROR: This driver may only be installed under Windows 2000 or later

:End
ENDLOCAL

:: Restore the current directory
POPD
